import os

output_dir = "output"
ns_day_sum = 0.0

# Loop over each simulation subdirectory in the output directory
for subdir in os.listdir(output_dir):
    subdir_path = os.path.join(output_dir, subdir)
    if not os.path.isdir(subdir_path):
        continue

    # Open the log file for this simulation and look for the ns/day value
    log_path = os.path.join(subdir_path, "md.log")
    with open(log_path, "r") as log_file:
        for line in log_file:
            if line.startswith("Performance:"):
                ns_day_str = line.split()[1]
                print("ns/day: {}".format(ns_day_str))
                ns_day_sum += float(ns_day_str)

# Print the total ns/day across all simulations
print("Total ns/day: {:.2f}".format(ns_day_sum))

